//  Listing 11.6. Zastosowanie konstruktora kopii 
//  do zwrotu obiektu z funkcji

#include <iostream>
using namespace std;

class String 
{
char *str; 				// dynamicznie zapamitywana tablica znakowa
int len;
char* allocate(const char* s) 		// funkcja prywatna
 { char *p = new char[len+1]; 		// przydzia pamici na stercie - dla obiektu
 if (p==NULL) exit(1); 			// jeli si nie powiodo - zakocz
 strcpy(p,s); 				// kopiuj tekst na stert
 return p; } 				// zwr wskanik do tekstu na stercie
public:
String (int length=0); 			// konstruktor konwertujcy / domylny
String(const char*); 			// konstruktor konwertujcy
String(const String& s); 		// konstruktor kopiujcy
~String (); 				// zwolnij dynamiczn pami
void operator += (const String&); 	// konkatenacja
void modify(const char*); 			// zmie zawarto tablicy
bool operator == (const String&) const; 	// porwnaj zawarto
const char* show() const; 			// zwr wskanik do tablicy
};

String::String(int length)
{ len = length;
str = allocate(""); 				// kopiuj pusty acuch znakw na stert
cout << " Zapocztkowany: '" << str <<"'\n"; }

String::String(const char* s)
{ len = strlen(s); 			// pomiar dugoci wejciowego tekstu
str = allocate(s); 			// przydziel pami, kopiuj tekst
cout << " Utworzony: '" << str <<"'\n"; }

String::String(const String& s) 	// konstruktor kopiujcy
{ len = s.len; 				// pomiar dugoci wejciowego tekstu
str = allocate(s.str); 			// przydziel pami, kopiuj tekst
cout << " Skopiowany: '" << str <<"'\n"; }

String::~String()
{ delete str; } 				// zwrot zwolnionej pamici na stercie
void String::operator += (const String& s) 	// referencyjny parametr
{ len = strlen(str) + strlen(s.str); 		// cakowita dugo
char* p = new char[len + 1]; 			// wystarczajca ilo miejsca na stercie
if (p==NULL) exit(1); 				// czy si powiodo?
strcpy(p,str); 					// kopiuj pierwsz cz rezultatu
strcat(p,s.str); 				// dodaj drug cz rezultatu
delete str; 					// wana czynno
str = p; } 				// teraz p moe sobie znika

bool String::operator==(const String& s) const 	// porwnaj zawarto
{ return strcmp(str,s.str)==0; } 		// strcmp() zwraca 0, jeli takie same

const char* String::show() const 		// chro dane przed zmianami
{ return str; }

void String::modify(const char a[]) 		// bez zarzdzania pamici
{ strncpy(str,a,len-1); 			// ochrona przed przepenieniem
str[len-1] = 0; } 				// prawidowe zakoczenie acucha znakw
String enterData()
{ cout << " Podaj miasto do odszukania: "; 	// komunikat: wpisz miasto
char data[200]; 				// rozwizanie do niezrczne
cin >> data; 					// wczytaj dane od uytkownika
return String(data); } 				// wywoaj konstruktor

int main()
{ 
enum { MAX = 4} ;
String data[4]; 				// baza danych, jako tablica zoona z obiektw
char *c[4] = { "Atlanta", "Boston", "Chicago", "Denver" };
for (int j=0; j<MAX; j++)
{ data[j] += c[j]; } 				// to znaczy - data[j].operator+=(c[j]);
String u = enterData(); 			// katastrofa bez konstruktora
int i;
for (i=0; i < MAX; i++) 			// i deklarowane poza ptl
{ if (data[i] == u) break; } 			// przerwij, jeli znalaze
if (i == MAX) 					// jeli nie znalaze i doszede do koca
cout << " Miasto " << u.show() << " nie zostao znalezione\n";
else
cout << " Miasto " << u.show() << " zostao znalezione\n";
return 0;
}
